
unit Default;

interface

uses
  Borland.Vcl.Contnrs , System.Configuration,
  System.Collections, System.ComponentModel, System.Web.Security, System.Text,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls;

type
  TActionPages = (apError, apNIL, apHome, apLogout, apProducts, apCategories, apCustomers, apOrders, apOrderDetails, apAdmins, apReviews, apAddProduct);

  TDefault = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    Header: System.Web.UI.WebControls.PlaceHolder;
    LeftPane: System.Web.UI.WebControls.PlaceHolder;
    Content: System.Web.UI.WebControls.PlaceHolder;
    RightPane: System.Web.UI.WebControls.PlaceHolder;
    Footer: System.Web.UI.WebControls.PlaceHolder;
    procedure OnInit(e: EventArgs); override;
  private
    Action : string;
    function ActionPage(const Action : string): TActionPages;
    function SetupMessage(const Head, Content : string) : System.Web.UI.Control;
  public
    { Public Declarations }
  end;

implementation

uses ucMessage, Security, Helper, HelperDB, DBAlias, DBAliasCollection;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TDefault.InitializeComponent;
begin
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}

procedure TDefault.Page_Load(sender: System.Object; e: System.EventArgs);
var
  sb : StringBuilder;
  DBAliasName : string;
begin
  // Header Section
  Header.Controls.Add(Page.LoadControl('~/UserControls/ucHeader.ascx'));

  // Left Pane
  LeftPane.Controls.Add(Page.LoadControl('~/UserControls/ucMenu.ascx'));


  if (Assigned(Page.Request.Params['Action']))  AND (Page.Request.Params['Action'] <> '') then
    Action := Request.Params['Action'].ToString
  else
    Response.Redirect('~/default.aspx?action=home');




  RightPane.Controls.Add(Page.LoadControl('~/UserControls/ucaspxDelphi.ascx'));

  if (TSecurity.IsAuthenticated) and Assigned(Session['TDBAlias']) then
  begin
    case ActionPage(Action) of
      apNIL:
        begin
          Response.Redirect('~/default.aspx?action=home');
        end;
      apHome:
        begin
          DBAliasName := Request.Cookies[THelper.CookieName].Values['dbAliasName'].ToString;
          Session.Add('TDBAlias',TDBAliasCollection.DBAlias(DBAliasName));

          sb := StringBuilder.Create;
          sb.Append('Select an option from the menu list to manage the appropriate section of the aspxDelphi.net STORE');
          sb.Append('<br>');
          sb.Append('<ul>');
          sb.Append('<li><b>Categories</b> - use this option to edit or edit store product categories,</li>');
          sb.Append('<li><b>Products</b> - use this option to edit or edit store products,</li>');
          sb.Append('<li><b>Customers</b> - use this option to view and edit customer orders and order details,</li>');
          sb.Append('<li><b>Reviews</b> - use this option to view and edit customer product reviews,</li>');
          sb.Append('<li><b>Admins</b> - use this option to add additional administrators.</li>');
          sb.Append('</ul>');
          sb.Append('<br>');
          sb.Append('<br>');

          sb.Append('&nbsp;&nbsp;&nbsp;Database: <b>' + DBAliasName + '</b>');

          //sb.Append('&nbsp;&nbsp;&nbsp;Database: <b>' + TDBAlias(Session['TDBAlias']).Name + '</b>');

          sb.Append('<br>');
          sb.Append('<br>');
          sb.Append('<blockquote>');
          sb.Append('Currently this store has:');
          sb.Append('<br>');
          sb.Append('<br>&nbsp;&nbsp;&nbsp;Customers: ' + THelperDB.CustomerCount.toString);
          sb.Append('<br>&nbsp;&nbsp;&nbsp;Orders: ' + THelperDB.OrdersCount.toString);
          sb.Append('<br>&nbsp;&nbsp;&nbsp;Products: ' + THelperDB.ProductsCount.toString);
          sb.Append('<br>&nbsp;&nbsp;&nbsp;Categories: ' + THelperDB.CategoriesCount.toString);
          sb.Append('</blockquote>');
          Content.Controls.Add(SetupMessage('Welcome to the aspxDelphi.net STORE Admin site', sb.ToString));
        end;
      apLogout:
        begin
          /// Log User Off from Cookie Authentication System
          FormsAuthentication.SignOut();

          // Invalidate roles token
          Response.Cookies[THelper.CookieName].Value := nil;
          Response.Cookies[THelper.CookieName].Expires := DateTime.Today;
          Response.Cookies[THelper.CookieName].Path := '/';

          Response.Redirect('~/default.aspx?action=home');
        end;
      apCustomers:
        begin
          Content.Controls.Add(Page.LoadControl('~/UserControls/ucCustomers.ascx'));
        end;
      apOrders:
        begin
          Content.Controls.Add(Page.LoadControl('~/UserControls/ucOrders.ascx'));
        end;
      apOrderDetails:
        begin
          Content.Controls.Add(Page.LoadControl('~/UserControls/ucOrderDetails.ascx'));
        end;
      apProducts:
        begin
          Content.Controls.Add(Page.LoadControl('~/UserControls/ucProducts.ascx'));
        end;
      apAddProduct:
        begin
          Content.Controls.Add(Page.LoadControl('~/UserControls/ucAddProduct.ascx'));
        end;
      apCategories:
        begin
          Content.Controls.Add(Page.LoadControl('~/UserControls/ucCategories.ascx'));
        end;
      apReviews:
        begin
          Content.Controls.Add(Page.LoadControl('~/UserControls/ucReviews.ascx'));
        end;
      apAdmins:
        begin
          Content.Controls.Add(Page.LoadControl('~/UserControls/ucAdmins.ascx'));
        end;
    end; //case
  end
  else
  begin
    Content.Controls.add(SetupMessage('Welcome to the aspxDelphi.net STORE Admin site', 'Please SignIn to gain access to the aspxDelphi.net STORE ADMIN!'));
    Content.Controls.Add(Page.LoadControl('~/UserControls/ucLogin.ascx'));
  end;

  Footer.Controls.Add(LiteralControl.Create('<span class=normal>Want to build a dynamic web site (shop or portal) using Delphi and ASP.NET? Contact <a href="mailto:webmaster@aspxdelphi.net">Zarko Gajic</a></span>!'));

end;

procedure TDefault.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;



function TDefault.ActionPage(const Action: string): TActionPages;
begin
  Result := apNIL;

  if Action.ToLower = 'error' then Result := apError;
  if Action.ToLower = 'home' then Result := apHome;
  if Action.ToLower = 'customers' then Result := apCustomers;
  if Action.ToLower = 'orders' then Result := apOrders;
  if Action.ToLower = 'orderdetail' then Result := apOrderDetails;
  if Action.ToLower = 'categories' then Result := apCategories;
  if Action.ToLower = 'products' then Result := apProducts;
  if Action.ToLower = 'addproduct' then Result := apAddProduct;
  if Action.ToLower = 'logout' then Result := apLogout;
  if Action.ToLower = 'admins' then Result := apAdmins;
  if Action.ToLower = 'reviews' then Result := apReviews;



end; (*ActionPage*)

function TDefault.SetupMessage(const Head, Content: string): System.Web.UI.Control;
var
  Msg : System.Web.UI.Control;
begin
  Msg := Page.LoadControl('~/UserControls/ucMessage.ascx');
  TucMessage(Msg).Head := Head;
  TucMessage(Msg).Content := Content;

  Result := Msg;
end; (*SetupMessage*)

end.

